<html>
<head>
    <title>Marcolin Order Confirmation (Order {{ $order->orderNumber or ''}})</title>
</head>
<body style="word-wrap: break-word; -webkit-nbsp-mode: space; -webkit-line-break: after-white-space;">
<table width="600px" cellpadding="5" cellspacing="0" border="0"
       style="font: 12px verdana; color: #000000; border-collapse: collapse;">
    <tr>
        <td colspan="8" align="left">
            <img width="166" vspace="0" hspace="0" border="0" alt="Marcolin Vision"
                 style="border: 0px;display: block;width: 100%;max-width: 250px;"
                 src="{!! $message->embed(public_path('images/logo_marcolin.jpg')) !!}">
        </td>
    </tr>
    <tr>
        <td colspan="8" align="left">
            Marcolin U.S.A. Eyewear Corp.<br>
            3140 Route 22 West<br>
            Somerville, NJ 08876<br>
            Tel: (800) 345 8482<br>
            infousa@marcolin.com<br>
        </td>
    </tr>
    <tr>
        <td colspan="8" align="right">
            @include('marcolin::partials.addressBlock', ['customer' => $order->customer])
            @if($order->customer->email != '')
                <br>Email: {{ $order->customer->email }}
            @endif
            @if($order->customer->fax != '')
                <br>Fax: {{ $order->customer->formatted_fax }}
            @endif
            @if($order->customer->telephone2 != '')
                <br>Tel: {{ $order->customer->formatted_telephone2 }}
            @endif
        </td>
    </tr>
    @if($order->salesGroup != null && $order->salesGroup != '')
    <tr>
        <td colspan="8" align="right">
            <b>Rep:</b> {{ $order->salesGroup or '' }}
        </td>
    </tr>
    @endif
    <tr>
        <td colspan="8" align="right">
            <b>Ref. Number:</b> {{ $order->orderNumber or '' }}
        </td>
    </tr>
    <tr>
        <td colspan="8" align="left">
            <b>Sell articles</b>
        </td>
    </tr>
    <tr style="border: 1px solid black; background-color: lightgray;">
        <td>Model</td>
        <td>Size</td>
        <td>Color</td>
        <td align="center">Quantity</td>
        <td align="center">Amount</td>
        <td align="center">Total Amount</td>
        <td>Description</td>
        <td>Type</td>
    </tr>
    @foreach($order->salesOrderItems as $salesOrderItem)
        <tr style="border: 1px solid black;">
            <td>{{ $salesOrderItem->unit->style }}</td>
            <td>{{ $salesOrderItem->unit->size }}</td>
            <td>{{ $salesOrderItem->unit->color }}</td>
            <td align="center">{{ $salesOrderItem->quantity }}</td>
            <td align="center">${{ number_format($salesOrderItem->unit->getCustomerPrice($order->customer), 2) }}</td>
            <td align="center">
                ${{ number_format($salesOrderItem->unit->getCustomerPrice($order->customer) * $salesOrderItem->quantity, 2) }}</td>
            <td>
                {{ $salesOrderItem->unit->colorDescription }}
                @if($salesOrderItem->itemNote != null && $salesOrderItem->itemNote != '')
                <br>
                {{ $salesOrderItem->itemNote }}
                @endif
            </td>
            <td>Sale</td>
        </tr>
    @endforeach
    <tr>
        <td>
            <br>
        </td>
    </tr>
    @if($order->total_sunglass_quantity > 0)
        <tr style="border-top: 1px solid black;">
            <td colspan="3" align="right">
                <b>Total Sunglass:</b>
            </td>
            <td align="center">
                {{ $order->total_sunglass_quantity }}
            </td>
            <td>
            </td>
            <td align="center">
                ${{ number_format($order->getTotalSunglassPrice($order->customer), 2) }}
            </td>
            <td colspan="2">
            </td>
        </tr>
    @endif
    @if($order->total_optical_quantity > 0)
        <tr style="border-top: 1px solid black;">
            <td colspan="3" align="right">
                <b>Total Ophthalmic:</b>
            </td>
            <td align="center">
                {{ $order->total_optical_quantity }}
            </td>
            <td>
            </td>
            <td align="center">
                ${{ number_format($order->getTotalOpticalPrice($order->customer), 2) }}
            </td>
            <td colspan="2">
            </td>
        </tr>
    @endif
    <tr style="border-top: 1px solid black;">
        <td colspan="3" align="right">
            <b>Total:</b>
        </td>
        <td align="center">
            {{ $order->total_quantity }}
        </td>
        <td>
        </td>
        <td align="center">
            ${{ number_format($order->getTotalPrice($order->customer), 2) }}
        </td>
        <td colspan="2">
        </td>
    </tr>
    <tr>
        <td>
        </td>
    </tr>
    <tr>
        <td align="right" valign="top">
            Notes:
        </td>
        <td colspan="7">
            {!! str_replace("\n", "<br>", $order->complete_notes) !!}
        </td>
    </tr>
</table>
</body>
</html>