<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Model;

class WebCart extends WebModel
{
    protected $table = 'WebCarts';
    protected $fillable = ['quantity', 'itemNote'];

    public function unit() {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    public function webUser() {
        return $this->belongsTo(WebUser::class);
    }

    public function scopeForUser($query, $webuserId) {
        return $query->where('webuser_id', $webuserId);
    }

    public function getExtendedPrice($customer) {
        return $this->unit->getCustomerPrice($customer) * $this->quantity;
    }

    public static function add(Unit $unit, $quantity = 1)
    {
        $instance = new static;
        $instance->webuser_id = Auth::id();
        $instance->unit_id = $unit->id;
        $instance->quantity = $quantity;
        $instance->save();
        return $instance;
    }

    public static function remove($userId, $unit_id)
    {
        $instance = new static;
        return $instance::where(['unit_id' => $unit_id, 'webuser_id' => $userId])->delete();
    }

    public static function cartItems($webUserId = false, $billToCustomerSegmentId = false) {
        // Get the web user. If and ID is provided, use it, otherwise, use who ever is logged in.
        if ($webUserId === false)
            $webUser = auth()->user();
        else
            $webUser = WebUser::find($webUserId);
        if (is_null($webUser)) return [];

        // Get the sold to customer.
        $soldToCustomer = b2b()->activeCustomer();

        $cartItems = self::forUser($webUser->id)
            ->whereHas("unit", function ($query) {
                return $query
                    ->webVisible()
                    ;
            })
            ->with("unit")
            ->get();

        foreach ($cartItems as $key => $cartItem) {
            $cartItems[$key]->customerPrice = $cartItem->unit->getCustomerPrice($soldToCustomer);
            $cartItems[$key]->discountPercent = $cartItem->unit->getCustomerDiscount($soldToCustomer);

            if ($cartItems[$key]->discountPercent > 0) {
                $cartItems[$key]->discountedPrice = round($cartItems[$key]->customerPrice - ($cartItems[$key]->customerPrice * ($cartItems[$key]->discountPercent / 100)), 2);
            } else {
                $cartItems[$key]->discountedPrice = $cartItems[$key]->customerPrice;
            }

            $cartItems[$key]->calculatedPrice = $cartItems[$key]->discountedPrice * $cartItems[$key]->quantity;
        }
        return $cartItems;
    }
    
    public static function getCartDiscount(){
        return rulesChecker::checkPromoRules(app('generalPromos'));
    }
    
}
