<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 8/3/18
 * Time: 7:49 AM
 */

namespace Marcolin\Models;

/**
 * Class PromotionSourceTrigger
 * @package Marcolin\Models
 */
class PromotionSourceTrigger extends PromotionTriggerDetails {
    protected $table = "PromotionSourceTriggers";
    protected $fillable = ['is_for_b2b', 'is_for_esb', 'commit_sequence'];

    /**
     * Boolean, all promo trigger types need to implement to use their specific logic
     * @param Customer $soldToCustomer
     * @param array $webCartItems
     * @return bool
     */
    public function isTriggered(Customer $soldToCustomer, $webCartItems = []) {
        return $this->is_for_b2b || !$this->is_for_esb;
    }

    /**
     * promo trigger types should implement if there post operations that should happen after promo is applied
     * @param $soldToCustomer
     * @return mixed
     */
    public function postTriggerOperation(Customer $soldToCustomer) {
        // TODO: Implement postTriggerOperation() method.
    }

    /**
     * Boolean, any promo trigger that can use the Almost Qualifying Header should implement this and return 'true'
     * otherwise return 'false'
     * @return bool
     */
    public function hasAlmostQualifyingField() {
        return false;
    }

    /**
     * Any promo trigger that can use the Almost Qualifying Header should implement this and
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @return bool
     */
    public function isAlmostQualifying(Customer $soldToCustomer, $webCartItems) {
        return false;
    }
}