
    @if(isset($alsobought) && count($alsobought))
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h3 class="panel-title text-center">Customers also bought...</h3>
                    </div>
                    <div class="panel-body" style="height: 280px">
                        <div id="best-sellers-carousel" class="owl-carousel owl-theme">
                            @foreach ($alsobought as $webStyle)
                                @include('partials.style-block', ['webStyle' => $webStyle, 'captionClass' => 'h4', 'containerStyle' => 'display: none;'])
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript">
            $(document).ready(function () {
                var bestSellersCarousel = $('#best-sellers-carousel');
                bestSellersCarousel.on({
                    'initialized.owl.carousel': function () {
                        bestSellersCarousel.find('.style-block-item').show();
                    }
                }).owlCarousel({
                    autoplay: true,
                    autoplayTimeout: 3500,
                    autoplayHoverPause: true,
                    loop: true,
                    responsive: {
                        0: {
                            items: 1,
                        },
                        320: {
                            items: 1
                        },
                        480: {
                            items: @if(auth()->user()) 2 @else 2 @endif,
                        },
                        768: {
                            items: @if(auth()->user()) 3 @else 3 @endif,
                        },
                        992: {
                            items: @if(auth()->user()) 3 @else 3 @endif,
                        },
                        1440: {
                            items: @if(auth()->user()) 4 @else 4 @endif,
                        },
                    },
                });
            });
        </script>
    @endif
