<?php

namespace Marcolin\Providers;

use Marcolin\Events\UserWasRegistered;
use Marcolin\Listeners\EmailNewUserAlert;
use Marcolin\Listeners\EmailNewUserConfirmation;
use Illuminate\Contracts\Events\Dispatcher as DispatcherContract;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class MarcolinB2BSharedEventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        UserWasRegistered::class => [
            EmailNewUserAlert::class,
            EmailNewUserConfirmation::class,
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @param  \Illuminate\Contracts\Events\Dispatcher  $events
     * @return void
     */
    public function boot(DispatcherContract $events)
    {
        parent::boot($events);
    }
}
