<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Model;

class WebPermission extends Model
{

    protected $table = 'WebPermissions';
    protected $fillable = ['name', 'slug', 'description', 'is_enabled'];
    public $timestamps = false;

    public function webUsers()
    {
        return $this->belongsToMany(WebUser::class, 'WebPermission_WebUser');
    }

    public function webRoles()
    {
        return $this->belongsToMany(WebRole::class, 'WebPermission_WebRole', 'webpermission_id', 'webrole_id');
    }
}