<?php

namespace Marcolin\Models;

use DB;

class UACReport extends WebModel
{
    protected $table = "UACReports";

    protected $fillable = ['webuser_id', 'reportName', 'is_home'];

    public function webUser()
    {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }

    public function viewerWebUsers()
    {
        return $this->belongsToMany(WebUser::class, 'UACReport_ViewerWebUser', 'uacreport_id', 'viewer_webuser_id');
    }

    public function uacReportModules()
    {
        return $this->belongsToMany(UACReportModule::class, 'UACReportModuleInstances', 'uacreport_id', 'uacreportmodule_id');
    }

    public function uacReportModuleInstances()
    {
        return $this->hasMany(UACReportModuleInstance::class, 'uacreport_id', 'id')
            ->with([
                'uacReportModuleInstanceSavedFilters',
                'uacReportModuleInstanceAlerts',
                'uacReportModule',
            ]);
    }

    public function getHasTriggeredAlertAttribute() {
        foreach ($this->uacReportModuleInstances as $instance) {
            if ($instance->has_triggered_alert) {
                return true;
            }
        }
        return false;
    }
}