<?php

namespace Marcolin\Models;

/**
 * Class PromotionCustomerTrigger_WebSilo
 * @package Marcolin\Models
 * @property integer $promotioncustomertrigger_id
 * @property integer $websilo_id
 * @property boolean $is_excluded
 */
class PromotionCustomerTrigger_WebSilo extends WebModel {
    protected $table = 'PromotionCustomerTrigger_WebSilo';
    protected $fillable = ['promotioncustomertrigger_id', 'websilo_id', 'is_excluded'];
    protected $casts = ['is_excluded' => 'boolean'];

    /**
     * Get the relationship to owning PromotionCustomerTrigger
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionCustomerTrigger() {
        return $this->belongsTo(PromotionCustomerTrigger::class,
            'promotioncustomertrigger_id', 'id');
    }

    /**
     * Get the relationship to the targeted WebSilo
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }


    // Scopes
    public function scopeTriggerWebSilo($query, $trigger_id, $websilo_id) {
        return $query
            ->where('promotioncustomertrigger_id', $trigger_id)
            ->where('websilo_id', $websilo_id)
            ;
    }

    public function scopeByWebSilo($query, $websilo_id) {
        return $query
            -> where('websilo_id', $websilo_id)
            ;
    }

    public function scopeByTrigger($query, $trigger_id) {
        return $query
            -> where('promotioncustomertrigger_id', $trigger_id)
            ;
    }

}