<?php
namespace Marcolin\Models;


class PromotionCodeTrigger_Code extends WebModel {
    protected $table = 'PromotionCodeTrigger_Code';
    protected $fillable = ['promotioncodetrigger_id', 'coupon_code', 'is_redeemed', 'commit_sequence'];

    /**
     * Get the relationship to owning-PromotionCodeTrigger
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionCodeTrigger() {
        return $this->belongsTo(PromotionCodeTrigger::class, 'promotioncodetrigger_id', 'id');
    }

    // Scopes
    public function scopeTriggerCode($query, $trigger_id, $code) {
        return $query
            ->where('promotioncodetrigger_id', $trigger_id)
            ->where('coupon_code', $code)
            ;
    }

    public function scopeByCode($query, $code) {
        return $query->where('coupon_code', $code);
    }

    public function scopeByTrigger($query, $trigger_id) {
        return $query->where('promotioncodetrigger_id', $trigger_id);
    }

    use HasCommitSequence;
}