<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Model;


class AutocatCatalogUnit extends WebModel
{
    protected $table = "AutocatCatalogUnits";
    protected $fillable = [
        'autocatcatalog_id',
        'autocatcatalogstyle_id',
        'unit_id',
        'default_status',
        'override_status',
        'order',
        'primary_unit',
    ];

    public function autocatCatalog()
    {
        return $this->belongsTo(AutocatCatalog::class, 'autocatcatalog_id', 'id');
    }


    public function autocatCatalogStyle()
    {
        return $this->belongsTo(AutocatCatalogStyle::class, 'autocatcatalogstyle_id', 'id');
    }

    public function unit(){
        return$this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    public function comments()
    {
        return $this->belongsToMany(AutocatCatalogComment::class, 'AutocatCatalogUnit_AutocatCatalogComment', 'autocatcatalogunit_id', 'comment_id')->wherePivot('deleted_at', '=', '0000-00-00 00:00:00');
    }

    public function defaultVisibility(){
        if($this->default_status === 1){
            return true;
        }else{
            return false;
        }
    }

    public function getDefaultStatusAttribute()
    {
        return $this->attributes['default_status'];
    }

    public function getOverrideStatusAttribute()
    {
        return $this->attributes['override_status'];
    }

    public function isDefaultShow(){
        if($this->default_status === 1){
            return true;
        }else{
            return false;
        }
    }

    public function isDefaultHide(){
        if($this->default_status === 0){
            return true;
        }else{
            return false;
        }
    }


    public function isOverrideShow(){
        if($this->override_status === 1){
            return true;
        }else{
            return false;
        }
    }

    public function isOverrideHide(){
        if($this->override_status === 0){
            return true;
        }else{
            return false;
        }
    }

    public function currentVisibility(){
        if($this->override_status === 1){
            return true;
        }else if($this->default_status === 1 && $this->override_status === null){
            return true;
        }else{
            return false;
        }
    }
    
    public function getIsNewAttribute() {
        $is_new_modifier = $this->autocatCatalogItemModifiers->where('modifier_type', 'is_new')->first();
        $is_new = isset($is_new_modifier) ? $is_new_modifier->modifier_value : 0;
        return $is_new;
    }

    public function getDefaultIsRxableAttribute() {
        return $this->item->webUnits->first()->unit->rxAble && $this->item->style->productType == 'S';
    }

    public function getIsRxableAttribute() {
        $is_rxable_modifier = $this->autocatCatalogItemModifiers->where('modifier_type', 'is_rxable')->first();
        $is_rxable = isset($is_rxable_modifier) ? $is_rxable_modifier->modifier_value : $this->default_is_rxable;
        return $is_rxable;
    }

    public function getPageBreakAfterAttribute() {
        $page_break_after_modifier = $this->autocatCatalogItemModifiers->where('modifier_type', 'page_break_after')->first();
        $page_break_after = isset($page_break_after_modifier) ? $page_break_after_modifier->modifier_value : 0;
        return $page_break_after;
    }

    public function getHasBeenEditedAttribute() {
        return $this->is_new == 1
            || $this->is_rxable != $this->default_is_rxable
            || $this->page_break_after == 1
            || count($this->comments) > 0
            ;
    }

    public function getColorAttribute(){
        return $this->unit->color;
    }

    public function getSizeAttribute(){
        return $this->unit->size;
    }

    public function scopeVisible( $query)
    {
        $query->where(function($q){
            return $q->where("override_status", "=",1)
                ->orWhere(function($q){
                    return $q->where("default_status", "=", 1)
                        ->whereNull("override_status");
                });
        });
        return $query;
    }

    public function getInCatalogAttribute() {
        return $this->override_status === 1 || ($this->override_status === null && $this->default_status === 1);
    }
}
