<?php

return [
    'emailDestinations' => [
        'orderAlert' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'babbott@visionwaresystems.com'),
            ],
        ],
        'orderConfirmation' => [
            'to' => [],
            'bcc' => [],
        ],
        'newUserAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_CUSTOMERSERVICE', 'babbott@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'babbott@visionwaresystems.com'),
            ],
        ],
        'newUserConfirmation' => [
            'to' => [],
            'bcc' => [],
        ],
        'registrationFailedAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_CUSTOMERSERVICE', 'babbott@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'babbott@visionwaresystems.com'),
            ],
        ],
        'requestCorrections' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_CUSTOMERSERVICE', 'babbott@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'babbott@visionwaresystems.com'),
            ]
        ],
        'requestBrand' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'babbott@visionwaresystems.com'),
            ]
        ],
        'feedback' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_CUSTOMERSERVICE', 'babbott@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'babbott@visionwaresystems.com'),
            ]
        ]
    ],
    'email' => [
        'orderSubmitted' => [
            'destination' => [env('MARCOLIN_CS_EMAIL', 'babbott@visionwaresystems.com')],
            'subject' => env('MARCOLIN_ORDER_SUBMITTED_EMAIL_SUBJECT', 'Marcolin B2B Order Submitted'),
        ],
    ],
    'customers' => [
        'stats' => [
            'groups' => [
                '' => 'Overall',
                'DIAGNOSTIC EXAM' => 'Diagnostic Exam',
                'REPAIR PARTS' => 'Repair Parts',
                'LAB & DISPENSING EQUIPMENT' => 'Lab & Dispensing Equipment',
                'CONSUMER ACCESSORIES' => 'Consumer Accessories',
                'PHARMACEUTICALS' => 'Pharmaceuticals',
                'SPORT/SUN PROTECTIVE EYEWEAR' => 'Sport / Sun Protective Eyewear',
                'SURGICAL' => 'Surgical',
                'LENSCARE & BRANDING' => 'Lenscare & Branding',
                'LAB SERVICES' => 'Lab Services',
                'INDUSTRIAL SAFETY EYEWEAR' => 'Industrial Safety Eyewear',
            ]
        ]
    ],
    'b2b' => [
        'url' => env('B2B_SERVER_URL')
    ],
    'uac' => [
        'url' => env('UAC_SERVER_URL')
    ],
    'assets' => [
        'url' => env('ASSET_SERVER_URL'),
        'nopic' => 'chrome/nopic',
        'tokenSalt' => 'sfed;ji365wJTEARr8y90fdhjniu',
        'sizes' => [
            'thumbnail' => [
                'width' => 80,
                'height' => 80,
            ],
            'thumbnailByHeight' => [
                'width' => -1,
                'height' => 80,
            ],
            'microByHeight' => [
                'width' => -1,
                'height' => 40,
            ],
            'small' => [
                'width' => 150,
                'height' => 150,
            ],
            'medium' => [
                'width' => 300,
                'height' => 300,
            ],
            'logo' => [
                'width' => -1,
                'height' => 45,
            ]
        ]
    ],
    'components' => [
        'bannerCarousel' => [
            'view' => 'marcolin::components.bannerCarousel',
            'defaultViewData' => [
                'bannerId' => '',
                'bannerTimeout' => 3500,
                'slides' => [
                    0 => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ],
            ]
        ],
        'jumbotron' => [
            'view' => 'marcolin::components.jumbotron',
            'defaultViewData' => [
                'webAssetId' => null,
            ]
        ],
        'promoTiles' => [
            'view' => 'marcolin::components.promoTiles',
            'defaultViewData' => [
                'tiles' => [
                    'left' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'center' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'right' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ]
            ]
        ],
        'children' => [
            'view' => 'marcolin::components.children',
            'defaultViewData' => [
                'types' => [
                    'children' => 'All',
                    'featuredChildren' => 'Featured',
                ],
                'layouts' => [
                    'normal' => 'Normal',
                    'large' => 'Large',
                    'jumbo' => 'Jumbo',
                ],
                'type' => 'featuredChildren',
                'layout' => 'normal',
                'showNames' => true,
            ]
        ],
        'allChildren' => [
            'view' => 'marcolin::components.allChildren',
            'defaultViewData' => [

            ]
        ],
        'userInfo' => [
            'view' => 'marcolin::components.userInfo',
            'defaultViewData' => [

            ],
        ],
        'bestSellers' => [
            'view' => 'marcolin::components.bestSellers',
            'defaultViewData' => [

            ]
        ],
        'assetsTable' => [
            'view' => 'marcolin::components.assetsTable',
            'defaultViewData' => [
                'assetsTableId' => 0,
                'webAssets' => [],
            ]
        ],
        'assetLink' => [
            'view' => 'marcolin::components.assetLink',
            'defaultViewData' => [
                'webAssetId' => null,
                'link' => [
                    'type' => null,
                    'target' => null,
                    'isPrivate' => false,
                ],
                'caption' => null,
            ]
        ],
    ],
    'outOfStockLabels' => [
        'Out of Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'inStockLabels' => [
        'In Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'defaultWebRoleSlug' => 'web-user',
    'jpPromoCollectionId' => env("JONATHAN_PAUL_FITOVERS_ID"),
    'jpPromoIgnoreId' => env("JONATHAN_PAUL_FITOVERS_IGNORE_ID"),
];