<?php

namespace Marcolin\Models;

/**
 * Class PromotionItemDiscountAction_Product
 * @package Marcolin\Models
 */
class PromotionItemDiscountAction_Product extends WebModel {
    protected $table = 'PromotionItemDiscountAction_Product';
    protected $fillable = ['promotionitemdiscountaction_id', 'is_excluded'];
    protected $casts = ['is_excluded' => 'boolean'];

    /**
     * Gets the relationship to the owning PromotionItemDiscountAction row
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function itemDiscountAction() {
        return $this->belongsTo(PromotionItemDiscountAction::class,
            'promotionitemdiscountaction_id', 'id');
    }

    // Scopes
    public function scopeActionProduct($query, $action_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionitemdiscountaction_id' => $action_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}