<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Builder;


class PrepackItem extends WebModel
{
    protected $table = "PrepackItems";

    function prepack()
    {
        return $this->belongsTo(Prepack::class, 'prepack_id', 'id');
    }

    function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }

    function scopeIsPrimary(Builder $query){
        return $query->where('primary_flag', '=', 1);
    }

    function scopeIsSubstitute(Builder $query){
        return $query->where('primary_flag', '=', 0);
    }
}
