@if($edit)
    <div class="mceNonEditable component-container" data-component-key="promoBanners">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>Promotions</h4>
        <p>Displays promotion banner(s) across the entire width of the page that cycle.</p>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('promoBanners', {
            menuText: 'Promotions',
            bladeTemplate: 'marcolin::components.promoBanners',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    <div id="promotions-carousel" class="owl-carousel owl-theme">
        @foreach(b2b()->eligiblePromotions() as $promotion)
            @if ($promotion->visible && strlen($promotion->homepage_banner_text) && !$promotion->hasCodeList())
                @include(
                    'promos.promoBlock',
                    [
                        'homepage' => true,
                        'link' => $promotion->homepage_banner_link,
                        'text' => $promotion->homepage_banner_text
                    ]
                )
            @endif
        @endforeach
    </div>

    <script type="text/javascript">
        $(document).ready(function () {
            $('#promotions-carousel').owlCarousel({
                center: true,
                items: 1,
                @if(count(b2b()->eligiblePromotions()) > 1) loop: true, @endif
                autoplay: true,
                autoplayTimeout: {{ isset($bannerTimeout) ? $bannerTimeout : '5000' }},
                autoplayHoverPause: true,
                dots: true,
            });
        });
    </script>
@endif