@if($edit)
    <div class="mceNonEditable component-container" data-component-key="autocat_style_sku_selector">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>Style SKU Selector</h4>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('autocat_style_sku_selector', {
            menuText: 'Autocat Style SKU Selector',
            bladeTemplate: 'marcolin::components.autocat_style_sku_selector',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    <div>
        <div class="style-info">
            <div class="form-inline">
                <div class="form-group">
                    <label class="control-label">Color: </label>
                    <select name="colors" id="colors-{{ $autocatCatalogStyle->style->webStyle->id }}" class="form-control input-sm style-selected-color" style="max-width: 200px;">
{{--                        @foreach($autocatCatalogStyle->style->webStyle->colors as $color => $colorDescription)--}}
                        @foreach ($autocatCatalogStyle->autocatCatalogUnitsInCatalog as $autocatCatalogUnit)
                            <option value="{{ $autocatCatalogUnit->unit->color }}">{{ $autocatCatalogUnit->unit->colorDescription }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <strong>Size: </strong>
                    <div class="btn-group btn-group-sm" data-toggle="buttons">
                        @foreach($autocatCatalogStyle->style->webStyle->sizes as $size)
{{--                        @foreach ($autocatCatalogStyle->autocatCatalogUnitsInCatalog as $autocatCatalogUnit)--}}
                            <label class="btn btn-default @if($loop->first) active @endif">
                                <input type="radio" class="unit-size-radio" name="sizes-{{ $autocatCatalogStyle->style->webStyle->id }}" id="sizes-{{ $autocatCatalogStyle->style->webStyle->id }}-{{ $size }}" value="{{$size}}" autocomplete="off" @if($loop->first) checked @endif>
                                {{ $size }}
                            </label>
                        @endforeach
                    </div>
                </div>
             </div>
        </div>
    </div>
@endif
