<?php

use Carbon\Carbon;
use Marcolin\Models\WebAsset;
use Marcolin\Models\WebCategory;
use Marcolin\Models\WebBrand;
use Marcolin\Models\WebStyle;
use Marcolin\Models\WebLandingPage;
use Marcolin\Models\WebUnit;


if (! function_exists('createAssetAccessToken')) {
    function createAssetAccessToken() {
        $salt = config('marcolin.assets.tokenSalt');
        $timestamp = Carbon::now()->getTimestamp();
        return ['timestamp' => $timestamp, 'token' => md5($salt . $timestamp . $salt . $timestamp . $salt)];
    }
}

if (! function_exists('validateAssetAccessToken')) {
    function validateAssetAccessToken($token, $timestamp) {
        $salt = config('marcolin.assets.tokenSalt');
        $now = Carbon::now();
        $then = Carbon::createFromTimestamp($timestamp);
        if ($now->subMinutes(5) > $then) return false;
        return $token == md5($salt . $timestamp . $salt . $timestamp . $salt);
    }
}

if (! function_exists('webAssetUrl')) {
    function webAssetUrl($options) {
        return WebAsset::urlHelper($options);
    }
}

if (! function_exists('webLinkUrl')) {
    function webLinkUrl($options) {
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return array_get($options, 'target', '');
            case 'webLandingPage':
                return route('landingpage.slug', [array_get($options, 'target')]);
            case 'webAsset':
                return WebAsset::urlHelper(['id' => $options['target'], 'download' => true, 'token' => true]);
        }
    }
}

if (! function_exists('webLinkTitle')) {
    function webLinkTitle($options) {
        $target = array_get($options, 'target', '');
        switch (array_get($options, 'type', 'url')) {
            case 'url':
                return $target;
            case 'webLandingPage':
                $webLandingPage = WebLandingPage::whereSlug($target)->first();
                return $webLandingPage ? $webLandingPage->name : '';
            case 'webAsset':
                $webAsset = WebAsset::find($target);
                return $webAsset ? $webAsset->name : '';
        }
    }
}

if (!function_exists('b2bLink')) {
    function b2bLink($model) {
        $url = config('marcolin.b2b.url', false);
        if (!$url) return false;
        switch (get_class($model)) {
            case WebUnit::class:
                return $url . '/f/' . $model->webStyle->slug;
            case WebStyle::class:
                return $url . '/f/' . $model->slug;
            case WebBrand::class:
                return $url . '/l/' . $model->slug;
            case WebCategory::class:
                return $url . '/c/' . $model->slug;
            case WebLandingPage::class:
                return $url . '/lp/' . $model->slug;
        }
        return false;
    }
}

if (!function_exists('canUser')) {
    function canUser($permission) {
        $user = Auth::user();
        if (is_null($user)) return false;
        if ($permission !== 'b2b-prices') {
            return $user->can($permission);
        } else {
            if (!$user->can('b2b-prices')) {
                return false;
            } else if (Session::has('show-price')){
                return Session::get('show-price') == 'true';
            } else {
                return true;
            }
        }
    }
}

if (!function_exists('b2b')) {
    function b2b() {
        return app('b2b');
    }
}