<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 8/11/16
 * Time: 9:33 AM
 */

namespace Marcolin\Console\Commands;

use Illuminate\Console\Command;
use Symfony\Component\Console\Output\OutputInterface;
use \Log;

class LoggingCommand extends Command {

    public function info($string, $verbosity = null) {
        $this->logDispatch($string, $verbosity);
        parent::info($string, $verbosity);
    }

    public function line($string, $style = null, $verbosity = null) {
        $this->logDispatch($string, $verbosity);
        parent::line($string, $style, $verbosity);
    }

    public function comment($string, $verbosity = null) {
        $this->logDispatch($string, $verbosity);
        parent::comment($string, $verbosity);
    }

    public function error($string, $verbosity = null) {
        $this->logDispatch($string, $verbosity);
        parent::error($string, $verbosity);
    }

    public function warn($string, $verbosity = null) {
        $this->logDispatch($string, $verbosity);
        parent::warn($string, $verbosity);
    }

    private function logDispatch($string, $verbosity) {
        switch ($verbosity) {
            case OutputInterface::VERBOSITY_NORMAL:
                Log::notice($string);
                break;
            case OutputInterface::VERBOSITY_VERBOSE:
                Log::notice($string);
                break;
            case OutputInterface::VERBOSITY_VERY_VERBOSE:
                Log::info($string);
                break;
            case OutputInterface::VERBOSITY_DEBUG:
                Log::debug($string);
                break;
            default:
                Log::notice($string);
                break;
        }
    }
}