<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 8/3/18
 * Time: 7:49 AM
 */

namespace Marcolin\Models;


class PromotionCodeTrigger extends PromotionTriggerDetails {

    protected $table = 'PromotionCodeTriggers';
    protected $fillable = ['code', 'commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'trigger',
            'PromotionTriggers', 'trigger_id', 'promotion_id');
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems) {
        return $this->code === session()->get('b2b.activePromoCode');
    }
}