<?php

namespace Marcolin\Models;

use DB;
use Illuminate\Database\Eloquent\Builder;

class Prepack extends WebModel
{
    protected $table = "Prepacks";
    protected $morphClass = 'prepack';


    public function prepackItems()
    {
        return $this->hasMany(PrepackItem::class, 'prepack_id', 'id');
    }

    public function primaryPrepackItems() {
        return $this->prepackitems()->isPrimary();
    }

    public function hasSubstitutes() {
        if(count($this->prepackitems()->isSubstitute()->get()) > 0){
            return true;
        }else{
            return false;
        }
    }

    public function substitutePrepackItems() {
        return $this->prepackitems()->isSubstitute();
    }

    public function scopeBySlug ($query, $slug) {
        return $query->where('slug', $slug);
    }

    public function webcarts()
    {
        return $this->morphMany(WebCart::class, 'cartable');
    }

    public function scopeIsActive ($query) {
        return
            $query
                ->where(function ($query) {
                    return
                        $query
                            ->where('start_date', '=', '0000-00-00 00:00:00')
                            ->orWhere('start_date', '<=', DB::raw('DATE(NOW())'))
                            ->orWhereNull('start_date')
                        ;
                })
                ->where(function ($query) {
                    return $query
                        ->where('end_date', '=', '0000-00-00 00:00:00')
                        ->orWhere('end_date', '>=', DB::raw('DATE(NOW())'))
                        ->orWhereNull('end_date')
                        ;
                })
            ;
    }

    public function getDisplayNameForUACAttribute() {
        return $this->prepack_name;
    }

    public function getCustomerPrice() {
        $totalPrice = 0;
        $activeCustomer = b2b()->activeCustomer();
        foreach ($this->prepackItems()->with('unit')->get() as $prepackItem) {
            $totalPrice += $prepackItem->unit->getCustomerPrice($activeCustomer);
        }
        return $totalPrice;
    }

    public function getCustomerDiscount($customer)
    {
        return 0;
    }

    public function primaryImage($width = false, $height = false)
    {
        return $this->prepackItems->first()->unit->primaryImage($width, $height);
    }
}
