@if($edit)
    <div class="mceNonEditable component-container" data-component-key="autocat_style_image">
        <a href="#" class="btn btn-danger pull-right delete-component">X</a>
        <h4>Style Image</h4>
    </div>
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('autocat_style_image', {
            menuText: 'Autocat Style Image',
            bladeTemplate: 'marcolin::components.autocat_style_image',
            init: function (body) {
            },
            serialize: function (componentNode) {
                return {};
            },
        });
    </script>
@endif

@if($view)
    <div class="row">
        <div class="col-tn-6">
            @foreach($autocatCatalogStyle->distinct_autocat_catalog_units_by_color as $autocatCatalogUnit)
                <a href="{{ $autocatCatalogStyle->style->webStyle->slugUrl() }}">
                    <img
                            data-unit-color="{{ $autocatCatalogUnit->unit->color }}"
                            style="@if(!$loop->first)display: none;@endif margin-bottom: 5px;"
                            src="{{ $autocatCatalogUnit->unit->webUnit->primaryImage(300, 150) }}"
                            alt="{{ $autocatCatalogStyle->style->style }}"
                            class="img-responsive unit-image"
                    >
                </a>
            @endforeach
        </div>
        <div class="col-tn-6">
            <div class="row">
                @foreach($autocatCatalogStyle->distinct_autocat_catalog_units_by_color as $autocatCatalogUnit)
                    <div class="style-unit col-tn-4 col-md-4 @if($loop->index >= 6) visible-lg @endif">
                        <div class="panel panel-default" style="margin: 0px;">
                            <div class="panel-body" style="padding: 3px;">
                                <img
                                        data-unit-color="{{ $autocatCatalogUnit->unit->color }}"
                                        src="{{ $autocatCatalogUnit->unit->webUnit->primaryImage(100, 80) }}"
                                        alt=""
                                        class="center-block img-responsive unit-thumbnail"
                                        title="{{ $autocatCatalogUnit->unit->color }} - {{ title_case($autocatCatalogUnit->unit->colorDescription) }}"
                                >
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endif
