<?php

namespace Marcolin\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


class OrderHistory extends WebModel
{
	protected $table = "OrderHistories";

	public function customer() {
	    return $this->hasOne(Customer::class, 'customer_id', 'id');
    }

    public function scopeForCustomer($query, Customer $customer) {
	    return $query->where('customer_id', $customer->id);
    }
}
