<?php

namespace Marcolin\Models;

use Auth;
use DB;
use Image as Image2;
use Storage;

/**
 * Marcolin\Models\Product
 *
 * @property mixed $id
 */
class Customer extends WebModel
{
	protected $table = 'Customers';

    public function brands() {
        return $this->belongsToMany(Brand::class, 'Brand_Customer');
    }
	public function orderHistories() {
	    return $this->hasMany(OrderHistory::class, 'customer_id', 'id');
    }

    public function lastOrderedStyle($style) {
	    return $this->orderHistories->where('style', $style)->sortByDesc('billingDate')->first();
    }
}

