<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Marcolin\SoftDeletes;

/**
 * Marcolin\Models\BaseModel
 *
 * @property-read mixed $id_string
 * @mixin \Eloquent
 */
class UuidModel extends Model
{
    protected $keyType = 'bin';
    public $timestamp = false;
    public $incrementing = false;

    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';

    use UuidForKey;
    use SoftDeletes;
//
//    public function getUuidFormattedAttribute() {
//        return substr($this->id_string, 8,8) . '-' . substr($this->id_string, 4,4) . '-' . substr($this->id_string, 0,4) . '-' . substr($this->id_string, 16,4) . '-' . substr($this->id_string, 20,12);
//    }
}
