<?php

namespace Marcolin\Models;
use Marcolin\SoftDeletes;

/**
 * Marcolin\Models\SalesOrder_LocationData
 *
 * @mixin \Eloquent
 */
class SalesOrder_LocationData extends UuidModel
{
	protected $table = "SalesOrder_LocationData";

    use SoftDeletes;

    public function salesOrder() {
        return $this->belongsTo(SalesOrder::class, 'salesOrder_id', 'id');
    }

    public function salesOrderLocationDecoded() {
        return $this->hasOne(SalesOrder_LocationDecoded::class, 'salesorderlocationdata_id', 'id');
    }

}
