<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 11/3/17
 * Time: 12:59 PM
 */

namespace Marcolin\Models;
use DB;

trait HasCommitSequence {
    public function save(array $options = []) {
        if ($options && $options['ignoreCommitSequence']) {
            unset($options['ignoreCommitSequence']);
            return parent::save($options);
        } else {
            //todo hilco had a note about this saving twice and us wanting to fix that, I don't know if we ever did
            DB::transaction(function () use ($options) {
                $commitSequence = DB::table($this->getTable())->lockForUpdate()->max('commit_sequence') + 1;
                $this->commit_sequence = $commitSequence;
                return parent::save($options);
            });
        }
    }

    public function delete() {
        //todo hilco had a note about this saving twice and us wanting to fix that, I don't know if we ever did
        DB::transaction(function() {
            $commitSequence = DB::table($this->getTable())->lockForUpdate()->max('commit_sequence') + 1;
            $this->commit_sequence = $commitSequence;
            parent::save();
            parent::delete();
        });
    }
}