<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 3/16/19
 * Time: 12:20 PM
 */

namespace Marcolin\Models;

/**
 * Class PromotionRedemptions
 * @package Marcolin\Models
 */
class PromotionRedemptions extends UuidModel {
    protected $table = 'PromotionRedemptions';
    protected  $fillable = ['promotion_id', 'salesorder_id', 'customer_id', 'webuser_id', 'code', 'commit_sequence'];

    // Relationships
    public function promotion() {
        return $this->belongsTo(Promotion::class, 'promotion_id', 'id');
    }

    public function salesOrder() {
        return $this->belongsTo(SalesOrder::class, 'salesorder_id', 'id');
    }

    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }

    public function webUser() {
        return $this->belongsTo(Webuser::class, 'webuser_id', 'id');
    }


    public static function hasRedeemed(Promotion $promotion, Customer $customer) {
        $promotionRedemption = self::promotionCustomer($promotion->id, $customer->id)->first();
        return isset($promotionRedemption);
    }

    // Scopes
    public function scopePromotionCustomer($query, $promotion_id, $customer_id) {
        return
            $query
                ->where('promotion_id', $promotion_id)
                ->where('customer_id', $customer_id)
            ;
    }

    public function scopeByPromotion($query, $promotion_id) {
        return $query->where('promotion_id', $promotion_id);
    }
}