<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 3/17/19
 * Time: 9:56 AM
 */

namespace Marcolin\Models;

/**
 * Trait HasProductTableTypeRelationship
 * @package Marcolin\Models
 */
trait HasProductTableTypeRelationship {
    /**
     * Gets the table name (relation) for the product type
     * e.g., product type 'webUnit' matches to table name WebUnits
     * @param $object
     * @param $tableType
     * @return mixed
     */
    public function getRelationForProductTableType($tableType) {
        if ($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $relationName;
    }
}