<?php

namespace Marcolin\Models;

use DB;
use Marcolin\Models\Enums\SalesTargetTypes;


class SalesTarget extends WebModel
{
    protected $table = "SalesTargets";

    public function salesRep()
    {
        return $this->belongsTo(SalesRep::class, 'salesrep_id', 'id')->withTrashed();
    }

    public function scopeSalesTargetType($query, SalesTargetTypes $salesTargetType)
    {
        return $query->where('targetType', $salesTargetType->getValue());
    }

    public function scopeForRep($query, SalesRep $salesRep) {
        return $query->where('salesrep_id', $salesRep->id);
    }

    public function getSalesTargetType() {
        return $this->targetType;
    }
}
