<?php

namespace Marcolin\Models;

class PromotionItemDiscountAction extends PromotionActionDetails
{
    protected $table = 'PromotionItemDiscountActions';
    protected $fillable = ['quantity_to_discount', 'discount_percent', 'discount_entire_order'];

    public function promotion()
    {
        return $this->morphToMany(Promotion::class, 'action', 'PromotionActions', 'promotion_id', 'promotionitemdiscountaction_id');
    }

    public function webBrands()
    {
        return $this
            ->morphedByMany(WebBrand::class, 'product', 'PromotionItemDiscountAction_Product', 'promotionitemdiscountaction_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionItemDiscountAction_Product.deleted_at');
    }

    public function getRelationForProductTableType($tableType)
    {
        //
        if ($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status)
    {
        // TODO: Implement takeAction() method.
        if ($this->discount_entire_order) {
            foreach ($status['items'] as $item) {
                $discountPercent = $this->discountPercent;
                $discountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $extendedDiscountAmount = $discountAmount * $item['quantity'];
                $baseDiscountAmount = round($item['basePrice'] * ($discountPercent / 100), 2);
                $discountedPrice = $item['basePrice'] - $baseDiscountAmount;
                $extendedPrice = $discountedPrice * $item['quantity'];

            }
        } else {
        }
    }
}
