<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 8/3/18
 * Time: 7:50 AM
 */

namespace Marcolin\Models;


class PromotionFreeItemAction extends PromotionActionDetails {

    protected $table = 'PromotionFreeItemActions';
    protected $fillable = ['any_product','num_free','excluded','commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'action',
            'PromotionActions', 'action_id', 'promotion_id');
    }

    public function webBrands() {
        return $this
            ->morphedByMany(WebBrand::class, 'product',
                'PromotionFreeItemAction_Product', 'promotionfreeitemaction_id')
            ->withPivot(['excluded'])
            ->whereNull('PromotionFreeItemAction_Product.deleted_at')
            ;
    }

    public function getRelationForProductTableType($tableType) {
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        } else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function takeAction(Customer $soldToCustomer, $webCartItems, &$status)
    {
        // TODO: Implement takeAction() method.
    }
}