<?php

namespace Marcolin\Models;


class PromotionCurrentOrderQuantityTrigger_Product extends WebModel {

    protected $table = 'PromotionCurrentOrderQuantityTrigger_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function currentOrderQuantityTrigger() {
        return $this->belongsTo(PromotionCurrentOrderQuantityTrigger_Product::class,
            'PromotionCurrentOrderQuantityTrigger_id', 'id');
    }

    public function scopeTriggerProduct($query, $trigger_id, $product_id, $product_type) {
        return $query->where(
            [
                'PromotionCurrentOrderQuantityTrigger_id' => $trigger_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;
}
