<?php

return [
    'emailDestinations' => [
        'orderAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_B2B_ORDERS', ''),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ],
        ],
        'guestOrderConfirmation' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_MARCOLIN_SAF_GUEST_ORDERS', ''),
                env('EMAIL_DESTINATION_MARCOLIN_B2B_ORDERS', ''),
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
                env('EMAIL_DESTINATION_MARCOLIN_CARLO', ''),
            ],
        ],
        'orderConfirmation' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_MARCOLIN_SAF_CUSTOMER_SERVICE', ''),
                env('EMAIL_DESTINATION_MARCOLIN_B2B_ORDERS', ''),
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ],
        ],
        'returnAuth' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_MARCOLIN_SAF_RETURNS', ''),
                env('EMAIL_DESTINATION_MARCOLIN_B2B_ORDERS', ''),
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ],
        ],
        'sampleReturnAuth' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_MARCOLIN_SAMPLE_RETURNS', ''),
                env('EMAIL_DESTINATION_MARCOLIN_B2B_ORDERS', ''),
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ],
        ],
        'newUserAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_B2B_REGISTRATION', ''),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ],
        ],
        'newUserConfirmation' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_MARCOLIN_B2B_REGISTRATION', ''),
            ],
        ],
        'registrationFailedAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_B2B_REGISTRATION', ''),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ],
        ],
        'requestCorrections' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_ACCOUNT_MANAGEMENT', ''),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ]
        ],
        'requestBrand' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ]
        ],
        'feedback' => [
            'to' => [
                env('EMAIL_DESTINATION_MARCOLIN_FEEDBACK', ''),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', ''),
            ]
        ]
    ],
    'email' => [
        'orderSubmitted' => [
            'destination' => [env('MARCOLIN_CS_EMAIL', 'marcolinsupport@visionwaresystems.com')],
            'subject' => env('MARCOLIN_ORDER_SUBMITTED_EMAIL_SUBJECT', 'Marcolin B2B Order Submitted'),
        ],
    ],
    'customers' => [
        'stats' => [
            'groups' => [
                '' => 'Overall',
                'DIAGNOSTIC EXAM' => 'Diagnostic Exam',
                'REPAIR PARTS' => 'Repair Parts',
                'LAB & DISPENSING EQUIPMENT' => 'Lab & Dispensing Equipment',
                'CONSUMER ACCESSORIES' => 'Consumer Accessories',
                'PHARMACEUTICALS' => 'Pharmaceuticals',
                'SPORT/SUN PROTECTIVE EYEWEAR' => 'Sport / Sun Protective Eyewear',
                'SURGICAL' => 'Surgical',
                'LENSCARE & BRANDING' => 'Lenscare & Branding',
                'LAB SERVICES' => 'Lab Services',
                'INDUSTRIAL SAFETY EYEWEAR' => 'Industrial Safety Eyewear',
            ]
        ]
    ],
    'b2b' => [
        'url' => env('B2B_SERVER_URL')
    ],
    'uac' => [
        'url' => env('UAC_SERVER_URL')
    ],
    'assets' => [
        'url' => env('ASSET_SERVER_URL'),
        'nopic' => 'chrome/nopic',
        'tokenSalt' => 'sfed;ji365wJTEARr8y90fdhjniu',
        'sizes' => [
            'thumbnail' => [
                'width' => 80,
                'height' => 80,
            ],
            'thumbnailByHeight' => [
                'width' => -1,
                'height' => 80,
            ],
            'microByHeight' => [
                'width' => -1,
                'height' => 40,
            ],
            'small' => [
                'width' => 150,
                'height' => 150,
            ],
            'medium' => [
                'width' => 300,
                'height' => 300,
            ],
            'logo' => [
                'width' => -1,
                'height' => 45,
            ]
        ]
    ],
    'components' => [
        'bannerCarousel' => [
            'view' => 'marcolin::components.bannerCarousel',
            'defaultViewData' => [
                'bannerId' => '',
                'bannerTimeout' => 3500,
                'slides' => [
                    0 => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ],
            ]
        ],
        'jumbotron' => [
            'view' => 'marcolin::components.jumbotron',
            'defaultViewData' => [
                'webAssetId' => null,
            ]
        ],
        'promoTiles' => [
            'view' => 'marcolin::components.promoTiles',
            'defaultViewData' => [
                'tiles' => [
                    'left' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'center' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'right' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ]
            ]
        ],
        'userInfo' => [
            'view' => 'marcolin::components.userInfo',
            'defaultViewData' => [

            ],
        ],
        'bestSellers' => [
            'view' => 'marcolin::components.bestSellers',
            'defaultViewData' => [

            ]
        ],
        'assetsTable' => [
            'view' => 'marcolin::components.assetsTable',
            'defaultViewData' => [
                'assetsTableId' => 0,
                'webAssets' => [],
            ]
        ],
        'assetLink' => [
            'view' => 'marcolin::components.assetLink',
            'defaultViewData' => [
                'webAssetId' => null,
                'link' => [
                    'type' => null,
                    'target' => null,
                    'isPrivate' => false,
                ],
                'caption' => null,
            ]
        ],
        'promoBanners' => [
            'view' => 'marcolin::components.promoBanners',
            'defaultViewData' => [

            ],
        ],
    ],
    'outOfStockLabels' => [
        'Out of Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'inStockLabels' => [
        'In Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'defaultWebRoleSlug' => 'web-user',
];