<?php

namespace Marcolin\Models;

use DB;

class UACReportModuleInstance extends WebModel
{
    protected $table = "UACReportModuleInstances";

    protected $fillable = ['uacreport_id', 'uacreportmodule_id', 'moduleInstanceName'];

    public function uacReport()
    {
        return $this->belongsTo(UACReport::class, 'uacreport_id', 'id');
    }

    public function uacReportModule()
    {
        return $this->belongsTo(UACReportModule::class, 'uacreportmodule_id', 'id');
    }

    public function uacReportModuleInstanceAlerts()
    {
        return $this->hasMany(UACReportModuleInstanceAlert::class, 'uacreportmoduleinstance_id', 'id');
    }

    public function uacReportModuleInstanceSavedFilters() {
        return $this->hasMany(UACReportModuleInstanceSavedFilter::class, 'uacreportmoduleinstance_id', 'id');
    }

    public function getHasTriggeredAlertAttribute() {
        foreach ($this->uacReportModuleInstanceAlerts as $alert) {
            if ($alert->is_triggered) {
                return true;
            }
        }
        return false;
    }

    public function getNameAttribute() {
        return $this->moduleInstanceName != null ? $this->moduleInstanceName : $this->uacReportModule->moduleName;
    }
}
