<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 8/14/18
 * Time: 1:44 PM
 */

namespace Marcolin\Models;


class PromotionItemDiscountAction_Product extends WebModel {

    protected $table = 'PromotionItemDiscountAction_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function itemDiscountAction() {
        return $this->belongsTo(PromotionItemDiscountAction_Product::class,
            'promotionitemdiscountaction_id', 'id');
    }

    public function scopeActionProduct($query, $action_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionitemdiscountaction_id' => $action_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;

}