<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 8/14/18
 * Time: 2:54 PM
 */

namespace Marcolin\Models;


class PromotionFreeItemAction_Product extends WebModel {

    protected $table = 'PromotionFreeItemAction_Product';
    protected $fillable = ['excluded', 'commit_sequence'];

    public function freeItemAction() {
        return $this->belongsTo(PromotionFreeItemAction_Product::class,
            'promotionfreeitemaction_id', 'id');
    }

    public function scopeActionProduct($query, $action_id, $product_id, $product_type) {
        return $query->where(
            [
                'promotionfreeitemaction_id' => $action_id,
                'product_id' => $product_id,
                'product_type' => $product_type
            ]
        );
    }

    use HasCommitSequence;

}