<?php

namespace Marcolin\Models;

use Illuminate\Database\Eloquent\Model;

class WebUsageLog extends WebModel {
    protected $table = 'WebUsageLogs';
    protected $fillable = ['user_id', 'url', 'ip_address', 'data', 'request_type', 'method', 'extra', 'extra2'];
    protected $casts = [
        'data' => 'array'
    ];

    public function setIpAddressAttribute($value) {
        $this->attributes['ip_address'] = ip2long($value);
    }

    public function getIpAddressAttribute() {
        return long2ip($this->attributes['ip_address']);
    }
    
}