<?php

namespace Marcolin\Models;

use DB;

/**
 * Marcolin\Models\WebForms
 *
 * @property integer $id
 * @property string $title
 * @property string $slug
 * @property string $date_modified
 * @property string $deleted_at
 */
class WebForms extends WebModel
{
    protected $table = "WebForms";
    protected $fillable = ['title','slug'];
    public static $contactUsSlug = 'contact-us-form';

    public function formFields() {
        return $this->belongsToMany(FormFields::class, 'WebForm_FormField', 'webform_id', 'formfield_id')->withPivot('order_num')->orderBy('pivot_order_num')->orderBy('id');
    }

    public function submits() {
        return $this->hasMany(WebFormSubmits::class, 'webform_id', 'id');
    }

}
