<?php

namespace Marcolin\Models;

use DB;
use Marcolin\Models\SelectsRelatedCount;

class WebAttribute_WebUnit extends WebModel
{
	protected $table = 'WebAttribute_WebUnit';
	protected $fillable = ['attribute_value'];

	public function webUnit() {
		return $this->belongsTo(WebUnit::class, 'webunit_id', 'id');
	}

	public function webAttribute() {
		return $this->belongsTo(WebAttribute::class, 'webattribute_id', 'id');
	}

    public function scopeInFamily($query, $webStyle) {
        $webStyleId = ($webStyle instanceof WebStyle) ? $webStyle->id : $webStyle;
        return $query->whereHas('webUnit', function ($query) use ($webStyleId) {
            return $query->inFamily($webStyleId);
        });
    }

    public function scopeInCollection($query, $webCollection) {
        $webCollectionId = ($webCollection instanceof WebBrand) ? $webCollection->id : $webCollection;
        return $query->whereHas('webUnit', function ($query) use ($webCollectionId) {
            return $query->inCollection($webCollectionId);
        });
    }

    public function scopeInCategory($query, $webCategory) {
        $webCategoryId = ($webCategory instanceof WebCategory) ? $webCategory->id : $webCategory;
        return $query->whereHas('webUnit', function ($query) use ($webCategoryId) {
            return $query->inCategory($webCategoryId);
        });
    }

    public function scopeInGroup($query, $webBrand) {
        $webBrandId = ($webBrand instanceof WebBrand) ? $webBrand->id : $webBrand;
        return $query->whereHas('webUnit', function ($query) use ($webBrandId) {
            return $query->inGroup($webBrandId);
        });
    }

    public function scopeIn($query, $model) {
        if ($model instanceof WebBrand) $query->inGroup($model);
        else if ($model instanceof WebCategory) $query->inCategory($model);
        else if ($model instanceof WebBrand) $query->inCollection($model);
        else if ($model instanceof WebStyle) $query->inFamily($model);
        $query->with('webAttribute')
            ->join('WebUnits', 'WebUnits.id', '=', 'WebAttribute_WebUnit.webunit_id')
            ->join('WebAttribute_WebStyle', function ($ons) {
                $ons
                    ->on('WebAttribute_WebStyle.webattribute_id', '=', 'WebAttribute_WebUnit.webattribute_id')
                    ->on('WebAttribute_WebStyle.webfamily_id', '=', 'WebUnits.webfamily_id')
                ;
            });
        return $query;
    }

}
