<?php

namespace Marcolin\Models;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class PromotionCurrentOrderQuantityTrigger extends PromotionTriggerDetails
{
    protected $table = 'PromotionCurrentOrderQuantityTriggers';
    protected $fillable = ['minimum_quantity', 'via_web', 'via_cst'];

    public function brands() {
        return $this
            ->morphedByMany(Brand::class, 'product', 'PromotionCurrentOrderQuantityTrigger_Product', 'PromotionCurrentOrderQuantityTrigger_id')
            ->withPivot(['excluded'])
        ;
    }

    public function styles() {
        return $this
            ->morphedByMany(Style::class, 'product', 'PromotionCurrentOrderQuantityTrigger_Product', 'PromotionCurrentOrderQuantityTrigger_id')
            ->withPivot(['excluded'])
            ;
    }

    public function getRelationForProductTableType($tableType) {
        //
        if($tableType === 'webFamily' || $tableType === 'webCategory') {
            $relationName = substr($tableType, 0, -1);
            $relationName .= 'ies';
        }
        else {
            $relationName = $tableType . 's';
        }
        return $this->$relationName();
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems) {
        return true;
    }
}
