<?php

namespace Marcolin\Models;

/**
 * Marcolin\Models\FeedbackType
 *
 * @property mixed $id
 * @property string $feedback_type_text
 * @property string $feedback_type_displayOrder
 * @property string $deleted_at
 * @property string $date_created
 * @property string $date_modified
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FeedbackType whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FeedbackType whereFeedbackTypeText($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FeedbackType whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FeedbackType whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Marcolin\Models\FeedbackType whereDeletedAt($value)
 * @mixin \Eloquent
 */
class FeedbackType extends WebModel
{
    protected $table = 'FeedbackTypes';

    public function feedbackSubjects()
    {
        return $this->hasMany(FeedbackSubject::class, 'feedback_type_id');
    }

    public function webFeedbackResponses()
    {
        return $this->hasMany(WebFeedbackResponse::class, 'feedback_type_id');
    }
}
