<?php

namespace Marcolin\Models;

/**
 * Class PromotionActionDetails
 * @package Marcolin\Models
 */
abstract class PromotionActionDetails extends WebModel {
    
    /**
     * Get relationship to PromotionActions row
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function action() {
        return $this->hasOne(PromotionAction::class, 'action_id', 'id');
    }

    /**
     * TODO NOTE: this may actually be obsolete, check if there are any real applications
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @param $status
     * @return mixed
     */
    public abstract function takeAction(Customer $soldToCustomer, $webCartItems, &$status);

    use HasCommitSequence;
}