<?php

namespace Marcolin\Models;

use DB;;

class UACReportModuleInstanceAlertContextSensitiveTrigger extends WebModel
{
    protected $table = "UACReportModuleInstanceAlertContextSensitiveTriggers";

    protected $fillable = ['value'];

    public function trigger() {
        return $this->hasOne(UACReportModuleInstanceAlertTrigger::class, 'trigger_id', 'id');
    }

    public function getIsTriggeredAttribute() {
        if (strlen(trim($this->value)) > 0) {
            $query = DB::table('B2BReturnItems')
                ->groupBy('style')
                ->groupBy('color')
                ->select(DB::raw('COUNT(*) AS count'))
                ->having(DB::raw('COUNT(*)'), '>', $this->value);

            $instance = $this->trigger->uacReportModuleInstanceAlert->uacReportModuleInstance;
            foreach ($instance->uacReportModuleInstanceSavedFilters as $filter) {
                if ($filter->filter_type == 'dateRange') {
                    $query->where('date_created', '>=', $filter->details->start_time)->where('date_created', '<=', $filter->details->end_time);
                }
            }

            return $query->count() > 0;
        } else {
            return false;
        }
    }

    public function getReadableDescriptionAttribute() {
        return "Single item return rate over ".$this->value.".";
    }
}
