<?php

namespace Marcolin\Models;

use Illuminate\Support\Facades\DB;


class AutocatCatalog extends WebModel
{
    protected $table = "AutocatCatalogs";

    
    public function autocatCatalogStyles()
    {
        return $this->hasMany(AutocatCatalogStyle::class, 'autocatcatalog_id', 'id');
    }

    public function autocatCatalogSearchFacets()
    {
        return $this->hasMany(AutocatCatalogSearchFacet::class, 'autocatcatalog_id', 'id');
    }

    public function autocatCatalogModifiers()
    {
        return $this->hasMany(AutocatCatalogModifier::class, 'autocatcatalog_id', 'id');
    }

    public function autocatLayout()
    {
        return $this->belongsTo(AutocatLayout::class, 'autocatlayout_id', 'id');
    }

    public function webUser()
    {
        return $this->belongsTo(WebUser::class, 'webuser_id', 'id');
    }

    public function getNameCleanAttribute() {
        $name = $this->name;

        preg_replace("/[^A-Za-z0-9]+/", '_', $name);

        return "$name.pdf";
    }

    public function getFilenameAttribute() {
        return "$this->id.pdf";
    }

    public function makeCopy($newCatalogName) {
        $newCatalog = new AutocatCatalog();
        $newCatalog->webUser()->associate($this->webUser);
        $newCatalog->autocatLayout()->associate($this->autocatLayout);
        $newCatalog->name = $newCatalogName;
        $newCatalog->status = 'STARTED';
        $newCatalog->save();

        foreach($this->autocatCatalogStyles as $autocatStyle) {
            $newStyle = new AutocatCatalogStyle();
            $newStyle->autocatcatalog_id = $newCatalog->id;
            $newStyle->style_id = $autocatStyle->style_id;
            $newStyle->order = $autocatStyle->order;
            $newStyle->default_status = $autocatStyle->default_status;
            $newStyle->override_status = $autocatStyle->override_status;
            $newStyle->save();

            foreach($autocatStyle->autocatCatalogUnits as $autocatUnit) {
                $newUnit = new AutocatCatalogUnit();
                $newUnit->autocatcatalog_id = $newCatalog->id;
                $newUnit->autocatcatalogstyle_id = $newStyle->id;
                $newUnit->unit_id = $autocatUnit->unit_id;
                $newUnit->order = $autocatUnit->order;
                $newUnit->default_status = $autocatUnit->default_status;
                $newUnit->override_status = $autocatUnit->override_status;
                $newUnit->save();
            }
        }
        
        foreach($this->autocatCatalogSearchFacets as $catalogSearchFacet) {
            $newFacet = new AutocatCatalogSearchFacet();
            $newFacet->autocatcatalog_id = $newCatalog->id;
            $newFacet->facet_name = $catalogSearchFacet->facet_name;
            $newFacet->facet_value = $catalogSearchFacet->facet_value;
            $newFacet->save();
        }

        foreach($this->autocatCatalogModifiers as $catalogModifier) {
            $newCatalogModifiers = new AutocatCatalogModifier();
            $newCatalogModifiers->autocatcatalog_id = $newCatalog->id;
            $newCatalogModifiers->modifier_type = $catalogModifier->modifier_type;
            $newCatalogModifiers->modifier_value = $catalogModifier->modifier_value;
            $newCatalogModifiers->save();
        }
    }
    
    public function getRelativePathAttribute(){
        return "autocat/{$this->filename}";
    }

    use HasAssets;
}
