<?php

namespace Marcolin\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;


class Order extends WebModel
{
	protected $table = "Orders";

    function orderItems() {
        return $this->hasMany(OrderItem::class, 'order_id', 'id');
    }

    function soldToCustomer() {
        return $this->belongsTo(Customer::class, 'soldTo_customer_id', 'id');
    }

    function shipToCustomer() {
        return $this->belongsTo(Customer::class, 'shipTo_customer_id', 'id');
    }

    function scopeOrderByDate($query, $order = 'desc') {
        return $query->orderBy('orderDate', $order);
    }

    public function getTotalQuantityAttribute() {
        $total = 0;
        foreach ($this->orderItems as $item) {
            $total += $item->orderQuantity;
        }
        return $total;
    }

    public function getFriendlyOrderStatusAttribute() {
        $total = 0;
        $shipped = 0;
        $cancelled = 0;
        foreach ($this->orderItems()->get() as  $orderItem) {
            $total += $orderItem->orderQuantity + $orderItem->orderQuantityFreeOfCharge;
            $shipped += $orderItem->orderQuantityDelivered + $orderItem->orderQuantityFreeOfChargeDelivered;
            $cancelled += $orderItem->orderQuantityCancelled + $orderItem->orderQuantityFreeOfChargeCancelled;
        }

        if ($total == 0 && $shipped == 0 && $cancelled > 0) {
            return 'Cancelled';
        } else if ($total == $shipped) {
            return 'Shipped';
        } else {
            return 'Open';
        }
    }
}
