<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 3/16/19
 * Time: 12:19 PM
 */

namespace Marcolin\Models;

/**
 * Class PromotionBrandTrigger_Brand
 * @package Marcolin\Models
 */
class PromotionBrandTrigger_Brand extends WebModel {
    protected $table = 'PromotionBrandTrigger_Brand';
    protected $fillable = ['promotionbrandtrigger_id', 'brand_id', 'commit_sequence'];

    /**
     * Gets the relationship to the owning PromotionBrandTrigger row
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionBrandTrigger() {
        return $this->belongsTo(PromotionBrandTrigger::class,
            'promotionbrandtrigger_id', 'id');
    }

    // Scopes
    public function scopeTriggerBrand($query, $trigger_id, $brand_id) {
        return $query->where(
            [
                'promotionbrandtrigger_id' => $trigger_id,
                'brand_id' => $brand_id
            ]
        );
    }

    use HasCommitSequence;
}