<?php
/**
 * Created by PhpStorm.
 * User: ntaylor
 * Date: 3/16/19
 * Time: 11:51 AM
 */

namespace Marcolin\Models;

/**
 * Class PromotionBrandTrigger
 * @package Marcolin\Models
 */
class PromotionBrandTrigger extends PromotionTriggerDetails {
    protected $table = 'PromotionBrandTriggers';
    protected $fillable = ['all_brands', 'commit_sequence'];

    // Overrides Model::boot(), used to define a specific 'deleted' state
    public static function boot() {
        parent::boot();
        // make sure all related rows in PromotionBrandTrigger_Brand are also deleted
        static::deleted(function (PromotionBrandTrigger $promotionBrandTrigger) {
            $promotionBrandTriggerBrands =
                PromotionBrandTrigger_Brand
                    ::where('promotionbrandtrigger_id', '=', $promotionBrandTrigger->id)
                    ->get()
            ;

            foreach ($promotionBrandTriggerBrands as $promotionBrandTriggerBrand) {
                $promotionBrandTriggerBrand->delete();
            }
        });
    }

    public function brands() {
        return $this->hasMany(PromotionBrandTrigger_Brand::class,
            'promotionbrandtrigger_id', 'id')
            ;
    }

    /**
     * Boolean, all promo trigger types need to implement to use their specific logic
     * @param Customer $soldToCustomer
     * @param array $webCartItems
     * @return mixed
     */
    public function isTriggered(Customer $soldToCustomer, $webCartItems = []) {
        return
            $this->all_brands ||
            array_intersect(
                $this->brands()->pluck('brand_id')->toArray(),
                $soldToCustomer->brands()->pluck('Brands.id')->toArray()
            )
            ;
    }

    /**
     * promo trigger types should implement if there post operations that should happen after promo is applied
     * @param $soldToCustomer
     * @return mixed
     */
    public function postTriggerOperation(Customer $soldToCustomer) {
        // TODO: Implement postTriggerOperation() method.
    }

    /**
     * Boolean, any promo trigger that can use the Almost Qualifying Header should implement this and return 'true'
     * otherwise return 'false'
     * @return bool
     */
    public function hasAlmostQualifyingField() {
        return false;
    }

    /**
     * Any promo trigger that can use the Almost Qualifying Header should implement this and
     * @param Customer $soldToCustomer
     * @param $webCartItems
     * @return bool
     */
    public function isAlmostQualifying(Customer $soldToCustomer, $webCartItems) {
        return false;
    }
}