<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 1/19/2017
 * Time: 10:10 AM
 */

namespace Marcolin\Events;


use Illuminate\Queue\SerializesModels;
use Marcolin\Models\WebUser;

class UserWasRegistered extends Event
{
    use SerializesModels;

    /** @var WebUser */
    public $webUser;

    /**
     * True if user self-registered, false if UAC created
     * @var bool
     */
    public $selfCreated;

    public $ipAddress;

    /**
     * @var string
     */
    public $temporaryPassword;

    public function __construct(WebUser $webUser, $ipAddress = false, $temporaryPassword = false, $selfCreated = true)
    {
        $this->webUser = $webUser;
        $this->selfCreated = $selfCreated;
        $this->temporaryPassword = $temporaryPassword;
        $this->ipAddress = $ipAddress ? $ipAddress : request()->ip();
    }
}