<?php

namespace Marcolin\Providers;
use App;
use Marcolin\Events\UserWasRegistered;
use Marcolin\Listeners\EmailNewUserAlert;
use Marcolin\Models\Customer;
use Marcolin\Models\Promotion;
use Marcolin\Models\WebAsset;
use Marcolin\Models\WebUnit;
use Marcolin\Models\Promo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Event;
use Illuminate\View\View;
use Illuminate\Support\ServiceProvider;

class MarcolinB2BSharedProvider extends ServiceProvider {
    public function register() {
        $this->mergeConfigFrom(__DIR__ . '/../../config/marcolin.php', 'marcolin');
        $this->mergeConfigFrom(__DIR__ . '/../../config/creditcards.php', 'creditcards');

        App::singleton('rateShop', function() {
            return new \Marcolin\RateShop();
        });

        App::singleton('generalPromos', function() {
            return Promo::active()->forAllCart()->with('rules')->get();
        });

        $this->app->singleton('b2b', function () {
            return new \Marcolin\B2BHelper();
        });
    }

    public function boot() {
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'marcolin');

        $this->publishes([
            __DIR__ . '/../../config/layoutcomponents.php' => config_path('layoutcomponents.php')
        ], 'marcolin-shared');

        $this->publishes([
            __DIR__ . '/../../config/marcolin.php' => config_path('marcolin.php')
        ], 'marcolin');

        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'marcolin');

        Relation::morphMap(WebAsset::getMorphMap());
        Relation::morphMap(Promotion::getMorphMap());
        Relation::morphMap([
            'customer' => Customer::class,
        ]);

        view()->creator('marcolin::components.*', function (View $view) {
            $data = $view->getData();
            if (!array_has($data, 'edit')) $view->with('edit', false);
            if (!array_has($data, 'wrap')) $view->with('wrap', false);
            if (!array_has($data, 'script')) $view->with('script', false);
            if (!array_has($data, 'view')) $view->with('view', false);
        });

        foreach (config('marcolin.components', []) as $key => $component) {
            view()->creator($component['view'], function (View $view) use ($component) {
                $viewData = $view->getData();
                $compData = array_dot($component['defaultViewData']);
                foreach ($compData as $kk => $vv) {
                    if (!array_has($viewData, $kk)) array_set($viewData, $kk, $vv);
                }
                $view->with($viewData);
            });
        }
    }
}