<?php
namespace Deployer;

require_once 'recipe/laravel.php';
require_once 'prepare.php';

$sshUser = get_current_user();
$sshPublicKey = '~/.ssh/id_rsa.pub';
$sshPrivateKey = '~/.ssh/id_rsa';
$phpFpmService='php7.0-fpm';

$reloadSupervisor = false;

/**
 * If the above credentials don't work for you, DO NOT change them in this file!
 * Create a deploy.config.php and override in it so that you don't mess it up for everyone else!
 * Sample:
 *
 *  <?php
 * $sshUser = 'junkrat';
 * $sshPublicKey = 'c:/users/junkrat/.ssh/id_rsa.pub';
 * $sshPrivateKey = 'c:/users/junkrat/.ssh/id_rsa';
 * $phpFpmService='php7.1-fpm';
 */
task('artisan:optimize', function () {})->desc('Execute artisan optimize');

if (file_exists('deploy.config.php')) require 'deploy.config.php';
set('visionware_current_user', $sshUser);


task('reload:php-fpm', function() use ($phpFpmService) {
    run('sudo service ' . $phpFpmService . ' restart');
})->desc('Restarts PHP');

task('reload:supervisor', function () {
    run('sudo service supervisor restart');
})->desc('Restarts Supervisor');

task('perms:app', function() {
    run('sudo chgrp -R {{group}} {{deploy_path}}');
    run('sudo chmod -R 777 {{deploy_path}}/shared/storage');
})->desc('Sets permissions and changes groups on application folders');


task('perms:server', function() {
    cd('/');
    run('if [ ! -d /var/www ]; then sudo mkdir -p /var/www; fi');
    run('sudo chgrp -R {{group}} /var/www');
    run('sudo chmod 775 /var/www');
    run('sudo chmod -R 777 /tmp');
})->desc('Sets permissions and changes groups on system folders');


task('deploy:cron', function() {
    run('sudo bash -c \'echo "* * * * * root php {{deploy_path}}/current/artisan schedule:run >> {{deploy_path}}/shared/storage/logs/lastCron.log 2>&1" > /etc/cron.d/hilco-api-schedule\'');
})->desc('Updates cron.d entry for Laravel Scheduler');

task('deploy:validate', function () {
    $tag = input()->getOption('tag');
    if (empty($tag)) {
        write('<error>Tag not specified! Use --tag option</error>');
        die();
    }
    writeln("You are attempting to deploy tag <comment>$tag</comment> to the <error>" . get('hostname') . "</error> environment.");
    $response = ask('Are you sure? Type the name of the environment to confirm.', '');
    if ($response !== get('hostname')) {
        write('<error>Validation failed!</error>');
        die();
    }

    $comments = [
        'My ultimate is charging!',
        'Protect the objective!',
        'Greetings!',
        'Justice rains from AUGGHH.',
        'Hm.',
        'SAKE!',
        'Protect the objective.',
        'Let\'s get the payload moving again.',
    ];

    set('deployNotes', ask('Provide a comment for this deployment', $comments[array_rand($comments)]));
})->desc('Validates local project settings');

task('deploy:mkdirs', function() {
    run('mkdir -p {{deploy_path}}/shared/storage/framework');
    run('mkdir -p {{deploy_path}}/shared/storage/framework/cache');
    run('mkdir -p {{deploy_path}}/shared/storage/framework/sessions');
    run('mkdir -p {{deploy_path}}/shared/storage/framework/views');
    run('mkdir -p {{deploy_path}}/shared/storage/app/db-blade-compiler/views');
    run('mkdir -p {{deploy_path}}/shared/storage/app/public');
    run('mkdir -p {{deploy_path}}/shared/storage/logs');
})->desc('Makes required app directories');


task('deploy:rollbar', function() {
    set('rollbar_local_username', get('visionware_current_user'));

    $params = [
        'access_token'   => get('rollbar_token'),
        'environment'    => get('rollbar_env'),
        'revision'       => run('cd {{current_path}} && git rev-parse HEAD'),
        'local_username' => get('rollbar_local_username'),
        'comment'        => get('current_tag') . " Notes: " . get('deployNotes', ''),
    ];
    $curl = run(sprintf('curl -s -XPOST --data "%s" https://api.rollbar.com/api/1/deploy/', http_build_query($params)));
    $run = json_decode($curl, true);
    if (isset($run['err'])) {
        writeln(sprintf('<error>An error occurred while notifying Rollbar ("%s").</error>', $run['message']));
        if (isVerbose()) {
            writeln(json_encode($run));
        }
    }
})->desc('Notify rollbar about the deployment');

set('current_tag', function () {
    return run("cd {{deploy_path}}/current && git symbolic-ref -q HEAD || git describe --tags --exact-match");
});

task('current', function () {
    writeln('Current release: ' . basename(get('current_path')));
    writeln('Current tag: ' . basename(get('current_tag')));
})->desc('Show current release.');

before('deploy', 'deploy:info');
before('deploy', 'deploy:validate');
before('deploy:prepare', 'perms:server');

after('deploy:shared', 'deploy:mkdirs');
after('deploy:writable', 'perms:app');
after('deploy', 'reload:php-fpm');
if ($reloadSupervisor) {
    after('deploy', 'reload:supervisor');
}
after('deploy', 'deploy:cron');
after('deploy', 'deploy:rollbar');
