<?php
namespace Deployer;

option('symlink', 's', \Symfony\Component\Console\Input\InputOption::VALUE_NONE, 'Use composer symlink functionality');
option('push', null, \Symfony\Component\Console\Input\InputOption::VALUE_NONE, 'Push tags after setting a tag');
task('prep', function() {})->desc('Prepare local composer stuff for deployment or development. Ask Chris how it works.');

task('prep:repos', function () {
    foreach (get('packagesToPrep') as $package) {
        $type = 'vcs';
        $url = $package['gitUrl'];
        if (input()->getArgument('stage') === 'local' && input()->getOption('symlink')) {
            $type = 'path';
            $url = $package['localPath'];
        }
        $output = runLocally("composer config repositories.$package[name] $type $url");
        if (strlen($output)) writeln('<info>'.$output.'</info>');
    }
})->desc('Update the repositories in the composer.json file.');

task('prep:packages', function () {
    foreach (get('packagesToPrep') as $package) {
        $version = input()->getArgument('stage') === 'local' ? '*@dev' : $package['version'];

        $output = runLocally("composer remove --no-scripts \"$package[package]\"");
        if (strlen($output)) writeln('<info>'.$output.'</info>');

        $output = runLocally("composer require --no-scripts \"$package[package]:$version\"");
        if (strlen($output)) writeln('<info>'.$output.'</info>');
    }
    foreach (get('packagesToPrep') as $package) {
        $output = runLocally("composer update --no-scripts \"$package[package]\"");
        if (strlen($output)) writeln('<info>'.$output.'</info>');
    }
})->desc('Update the package definitions in the composer.json file.');

task('tag', function () {
    writeln('<info>Fetching tags...</info>');
    $output = runLocally('git fetch --tags');
    if (strlen($output)) writeln('<info>'.$output.'</info>');
    $tags = explode("\n", runLocally('git tag -l'));
    foreach ($tags as $index=>$tag) {
        $tags[$index] = trim($tag);
    }
    $suffix = 0;
    do {
        $newTag = 'deploy_' . date('Ymd') . str_pad($suffix, 2, '0', STR_PAD_LEFT);
        $suffix++;
        if ($suffix > 99) die('ERROR');
    } while (in_array($newTag, $tags));
    writeln("<info>Using tag $newTag</info>");
    runLocally("git tag $newTag");

    if (input()->getOption('push')) {
        $output = runLocally("git push --tags");
        if (strlen($output)) writeln('<info>'.$output.'</info>');
    }
})->local()->desc('Create a deploy tag');


after('prep', 'prep:repos');
after('prep', 'prep:packages');

